/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.spruceui.hud;

import dev.lambdaurora.spruceui.event.OpenScreenCallback;
import dev.lambdaurora.spruceui.event.ResolutionChangeCallback;
import dev.lambdaurora.spruceui.hud.Hud;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import org.jetbrains.annotations.NotNull;

public class HudManager {
    private static final Map<class_2960, Hud> HUDS = new Object2ObjectOpenHashMap();

    public void initialize() {
        HudRenderCallback.EVENT.register((matrices, tickDelta) -> HUDS.forEach((id, hud) -> {
            if (hud.isEnabled() && hud.isVisible()) {
                hud.render(matrices, tickDelta);
            }
        }));
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            if (!HudManager.canRenderHuds(client)) {
                return;
            }
            HUDS.forEach((id, hud) -> {
                if (hud.isEnabled() && hud.isVisible() && hud.hasTicks()) {
                    hud.tick();
                }
            });
        });
        OpenScreenCallback.EVENT.register((client, screen) -> HudManager.initAll(client, client.method_22683().method_4486(), client.method_22683().method_4502()));
        ResolutionChangeCallback.EVENT.register(client -> HudManager.initAll(client, client.method_22683().method_4486(), client.method_22683().method_4502()));
    }

    protected static void initAll(@NotNull class_310 client, int screenWidth, int screenHeight) {
        if (!HudManager.canRenderHuds(client)) {
            return;
        }
        HUDS.forEach((id, hud) -> {
            if (hud.isEnabled()) {
                hud.init(client, screenWidth, screenHeight);
            }
        });
    }

    public static void register(@NotNull Hud hud) {
        if (HUDS.containsKey(hud.getIdentifier())) {
            throw new IllegalArgumentException("Cannot register the same HUD twice!");
        }
        HUDS.put(hud.getIdentifier(), hud);
    }

    public static void unregister(@NotNull class_2960 identifier) {
        HUDS.remove(identifier);
    }

    public static void unregister(@NotNull Hud hud) {
        HudManager.unregister(hud.getIdentifier());
    }

    public static boolean canRenderHuds(@NotNull class_310 client) {
        return client.field_1687 != null && (!client.field_1690.field_1842 || client.field_1755 != null);
    }

    public static Optional<Hud> getHud(@NotNull class_2960 identifier) {
        return Optional.ofNullable(HUDS.get(identifier));
    }

    public static Collection<Hud> getHuds() {
        return HUDS.values();
    }
}

